import { async,
        ComponentFixture,
        TestBed } from '@angular/core/testing'
import * as Axe from 'axe-core'
import { HttpModule} from '@angular/http'
import { ReactiveFormsModule } from '@angular/forms'
import { KarmaHelper } from '../../../../../karma/karma-helper'
import { RouterTestingModule } from '@angular/router/testing'

import { FhirPatientComponent } from './patient.component';
import { FhirPatient } from '../../../mccf-data/fhir/fhir-patient'

describe('FhirPatientComponent', () => {
  let component: FhirPatientComponent
  let fixture: ComponentFixture<FhirPatientComponent>

  beforeEach(async(() => {

    TestBed.configureTestingModule({
      imports: [
        ReactiveFormsModule,
        HttpModule,
        RouterTestingModule.withRoutes([])
      ],
      declarations: [
        FhirPatientComponent
      ],
      providers: []
    }).compileComponents()
      .then(()=>{
        fixture = TestBed.createComponent(FhirPatientComponent)
      })

  }))

  beforeEach(()=>{
    component = fixture.componentInstance
    component.ngOnInit()
    let pat = new FhirPatient()
    pat.age = '99'
    component.pat = pat
    fixture.detectChanges()
  })

  afterEach(function () {
    TestBed.resetTestingModule()
  });

  it('should have a patient loaded', ((done)=>{
    expect(component.pat.age).toEqual('99')
    done()
  }))

  it('should have no accessibility issues', ((done) => {
    // console.error(' @@@@@@@@@@@@@ html='+document.body.innerHTML)

    Axe.run(document, KarmaHelper.axeOptions()).then((result)=>{
      KarmaHelper.axeViolationLog(result)
      expect(result.violations.length).toEqual(0)
      done()
    }).catch((error)=>{
        console.error('AXE-CORE ERROR:'+error)
    })
  }))
})
